////////////////////////////////////////////////////////////////////////////////
//
// © 1999 – 2019 OneSpan North America Inc. All rights reserved.
// All rights reserved. https://www.onespan.com/
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@class OrchestrationWarning;

/**
 * <p>The {@link OrchestrationWarningDelegate} interface defines the delegate that can be implemented
 * in order to be informed of warnings during the {@link OrchestrationProtocol} lifecycle.</p>
 * <p>It is the main way for the {@link OrchestrationProtocol} to report warnings. It is optional and can
 * be provided to the {@link OrchestratorBuilder} via
 * {@link OrchestratorBuilder#setWarningDelegate:(id<OrchestrationWarningDelegate>)}.<br/>
 * The {@link OrchestrationWarningDelegate} used by the {@link OrchestrationProtocol} can also be modified
 * during its lifecycle via {@link OrchestrationProtocol#setWarningDelegate:(id<OrchestrationWarningDelegate>)}.</p>
 */
NS_REFINED_FOR_SWIFT
@protocol OrchestrationWarningDelegate <NSObject>

/**
 * delegate that will be called when an warning occurred
 * @param warning warning to return
 */
- (void)orchestrationWarning:(OrchestrationWarning *)warning;

@end

NS_ASSUME_NONNULL_END
